%define prefix   /usr

Summary: Utility to administer the Linux Virtual Server
Name: ipvsadm
Version: 1.11
Release: 4
Copyright: GNU General Public Licence
URL: http://www.LinuxVirtualServer.org/
Packager: Horms <horms@vergenet.net>	P.Copeland <copeland@redhat.com>
Group: Applications/System
Source0: http://www.LinuxVirutalServer.org/software/ipvsadm-%{version}.tar.gz
BuildRoot: /var/tmp/%name-%{PACKAGE_VERSION}-root
Docdir: %{prefix}/doc
Provides: %{name}-%{version}
Obsoletes: ipvsadm <= 1.10
Conflicts: piranha <= 0.4.14

%description
ipvsadm is a utility to administer the IP virtual server services
offered by the Linux kernel augmented with the virtual server patch.


%prep
%setup -n ipvsadm


%build
CFLAGS="${RPM_OPT_FLAGS}" make


%install
rm -rf $RPM_BUILD_ROOT
mkdir -p ${RPM_BUILD_ROOT}/{sbin,usr/man/man8}
BUILD_ROOT=${RPM_BUILD_ROOT} make install

#File finding code thanks to Samuel Flory of VA Linux Systems
cd ${RPM_BUILD_ROOT}
# Directories
find . -type d | sed '1,2d;s,^\.,\%attr(-\,root\,root) \%dir ,' \
  > ${RPM_BUILD_DIR}/%{name}-%{version}-%{release}.files
# Files
find . -type f | sed "s,^\.\(.*\),%attr (-\,root\,root) \1*," \
  >> ${RPM_BUILD_DIR}/%{name}-%{version}-%{release}.files
# Symbolic links
find . -type l | sed 's,^\.,\%attr(-\,root\,root) ,' \
  >> ${RPM_BUILD_DIR}/%{name}-%{version}-%{release}.files


%clean
rm -rf $RPM_BUILD_DIR/%{name}
rm -rf $RPM_BUILD_ROOT
rm ${RPM_BUILD_DIR}/%{name}-%{version}-%{release}.files


%files -f ../%{name}-%{version}-%{release}.files
%doc README


%changelog
* Thu Jul  6 2000 Wensong Zhang <wensong@linuxvirtualserver.org>
- Changed to build rpms on the ipvsadm tar ball directly

* Wed Jun 21 2000 P.Copeland <copeland@redhat.com>
- fixed silly install permission settings

* Mon Jun 19 2000 P.Copeland <copeland@redhat.com>
- Added 'dist' and 'rpms' to the Makefile
- Added Obsoletes tag since there were early versions
  of ipvsadm-*.rpm that installed in /sbin
- Obsolete tag was a bit vicious re: piranha

* Mon Apr 10 2000 Horms <horms@vergenet.net>
- created for version 1.9
